@extends('layouts.app')

@section('title', 'AI Assistant')

@section('content')
<div class="tw-max-w-3xl tw-mx-auto tw-p-4">
    <h1 class="tw-text-2xl tw-font-semibold tw-mb-4">AI Assistant</h1>

    <div id="chat" class="tw-bg-white tw-border tw-rounded tw-p-4 tw-h-[60vh] tw-overflow-y-auto tw-space-y-3"></div>

    <form id="chat-form" class="tw-mt-4 tw-flex tw-gap-2">
        <input id="chat-input" name="message" type="text" class="tw-flex-1 tw-border tw-rounded tw-px-3 tw-py-2" placeholder="Ask a question about your data..." maxlength="4000" required />
        <button type="submit" class="tw-bg-blue-600 tw-text-white tw-rounded tw-px-4 tw-py-2">Send</button>
    </form>

    <p class="tw-text-xs tw-text-gray-500 tw-mt-3">Answers are limited to information you can access.</p>
</div>

<script>
const chatEl = document.getElementById('chat');
const formEl = document.getElementById('chat-form');
const inputEl = document.getElementById('chat-input');

function addMsg(role, text, meta = {}) {
  const wrap = document.createElement('div');
  wrap.className = role === 'user' ? 'tw-text-right' : 'tw-text-left';
  const bubble = document.createElement('div');
  bubble.className = role === 'user' ? 'tw-inline-block tw-bg-blue-600 tw-text-white tw-rounded tw-px-3 tw-py-2' : 'tw-inline-block tw-bg-gray-100 tw-rounded tw-px-3 tw-py-2';
  bubble.textContent = text;
  wrap.appendChild(bubble);
  if (role === 'assistant' && meta.message_id) {
    const rate = document.createElement('div');
    rate.className = 'tw-text-xs tw-text-gray-500 tw-mt-1';
    const up = document.createElement('button');
    up.textContent = '👍'; up.className = 'tw-mr-2';
    const down = document.createElement('button');
    down.textContent = '👎';
    const disable = () => { up.disabled = true; down.disabled = true; };
    up.addEventListener('click', async () => {
      disable();
      try { await fetch("{{ url('/ai-chat/rate') }}", { method:'POST', headers:{'Content-Type':'application/json','X-CSRF-TOKEN':document.querySelector('meta[name="csrf-token"]').getAttribute('content')}, body: JSON.stringify({ id: meta.message_id, rating: 1 }) }); } catch(e) {}
    });
    down.addEventListener('click', async () => {
      disable();
      try { await fetch("{{ url('/ai-chat/rate') }}", { method:'POST', headers:{'Content-Type':'application/json','X-CSRF-TOKEN':document.querySelector('meta[name="csrf-token"]').getAttribute('content')}, body: JSON.stringify({ id: meta.message_id, rating: -1 }) }); } catch(e) {}
    });
    rate.appendChild(up); rate.appendChild(down);
    wrap.appendChild(rate);
  }
  chatEl.appendChild(wrap);
  chatEl.scrollTop = chatEl.scrollHeight;
}

formEl.addEventListener('submit', async (e) => {
  e.preventDefault();
  const msg = inputEl.value.trim();
  if (!msg) return;
  addMsg('user', msg);
  inputEl.value = '';

  const btn = formEl.querySelector('button[type="submit"]');
  const old = btn.textContent; btn.textContent = 'Sending...'; btn.disabled = true;

  try {
    // Try to auto-detect page supplier context via meta tags if present
    const metaSupId = document.querySelector('meta[name="current-supplier-id"]');
    const metaSupName = document.querySelector('meta[name="current-supplier-name"]');
    const pageSupplierId = metaSupId ? parseInt(metaSupId.getAttribute('content') || '0', 10) : 0;
    const pageSupplierName = metaSupName ? (metaSupName.getAttribute('content') || '') : '';

    const res = await fetch("{{ url('/ai-chat/message') }}", {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
        'Accept': 'application/json',
      },
      body: JSON.stringify({ message: msg, page_supplier_id: pageSupplierId > 0 ? pageSupplierId : undefined, page_supplier_name: pageSupplierName || undefined })
    });
    const data = await res.json();
    if (!data.ok) throw new Error('Request failed');
    addMsg('assistant', data.reply, { message_id: data.message_id });
  } catch (err) {
    addMsg('assistant', 'Sorry, there was an error sending your message.');
  } finally {
    btn.textContent = old; btn.disabled = false;
  }
});
</script>
@endsection
